;;; -*- Mode:Common-Lisp; Package:USER; Fonts:(MEDFNT HL12B HL12BI); Base:10 -*-

;;;			    RESTRICTED RIGHTS LEGEND
;;;
;;; Use, duplication, or disclosure by the Government is subject to restrictions
;;; as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data and
;;; Computer Software clause at 52.227-7013.

;;;			 TEXAS INSTRUMENTS INCORPORATED
;;;				  P.O. BOX 2909
;;;			       AUSTIN, TEXAS 78769

;;; Copyright (C) 1987-1989 Texas Instruments Incorporated.  All rights reserved.


;1; Change History*
;1; Date         Person         Change*
;1;---------------------------------------------------------------------------*
;1; 09/22/87    KJF       Added new file - definitions.lisp*
;1; 03/10/87    KJF       Had to shadow BITBLT-BLINKER because GWIN defines its own and*
;1;                          the WS has already defined one (see SYS:WINDOW;BLINKERS.LISP and*
;1;                          SYS:GWIN;BBBLINKER.LISP).*
;1; 03/10/87    KJF       Uncommented cm???-font specifications for :module RFONT.  This was*
;1;                          done because when trying to load a Release 2 picture file, an error*
;1;                          occurred of CMR5-FONT being undefined (unbound?).*
;1;                         Was commented out by JEB during conversion to Rel 3.*
;1;*



(defpackage "GWIN" (:size  1000) (:use "W" "TICL" "LISP")
	    (:shadow "BITBLT-BLINKER"))


;1;;*
;1;; DEFSYSTEM*
;1;;*
;1;; OVERVIEW*
;1;;*
;1;; This is the system definition for the graphics window flavor.  This also defines all the graphics*
;1;; objects and the manipulation routines needed to maintain them in a world and map them to a*
;1;; window.*
;1;;*
 
(DEFSYSTEM GRAPHICS-WINDOW
  (:NAME		"Graphics Window")
  (:NICKNAMES		"Graphics-Window")
  (:SHORT-NAME		"GWin")
  (:PATHNAME-DEFAULT	"sys:gwin;")
  (:PATCHABLE		"sys:patch.gwin;" patch)
  (:WARNINGS-PATHNAME-DEFAULT "sys:cwarns;gwin.lisp")

  (:MODULE DEFS         "definitions") ;1; added 09/22/87 KJF.*
  (:MODULE MACRO	"macros")
  (:MODULE UTILI	("utility" "draw"))
  (:MODULE BBBLI	("bbblinker"))
  (:MODULE CURSO	"cursor")
  (:MODULE BASEE	"basic-graphics-entity")
  (:MODULE ENTYS	("arc-entity" "circle-entity" "line-entity" "rectangle-entity"
			 "ruler-entity" "spline-entity" "subpicture-entity" "text-entity"
			 "triangle-entity" "polyline-entity"))
  (:MODULE ENTS1	"backgrpic-entity")
  (:MODULE WORLD	"world")
  (:MODULE BASEW	"mouse-handler")
  (:MODULE WINDO	"window")
  (:MODULE FONT		"raster-font")
  (:MODULE RASTR	"raster-entity")
  (:MODULE PRINT	"print")
  (:MODULE RFONT	("tr10-font" "hl12-font" "hl12b-font" "medfnt-font"
			 "bigfnt-font" "mets-font" "metsi-font" "43vxms-font"
			 "cmr5-font" "cmb8-font" "cmr10-font" "cmold-font"
			 "cmdunh-font" "cmr18-font"
			 ))
  (:MODULE STARTER-KIT	("sys:gwin.starter-kit;-read-me-"
			 "sys:gwin.starter-kit;examples.picture"))
  (:MODULE AUX		("sys:site;gwin.system" "sys:site;graphics-window.system"))
	

  (:AUXILIARY	      AUX)
  (:COMPILE-LOAD      DEFS)
  (:COMPILE-LOAD      MACRO
		      (:FASLOAD DEFS)
		      (:FASLOAD DEFS))
  (:COMPILE-LOAD-INIT UTILI (MACRO)
		      (:FASLOAD DEFS MACRO)
		      (:FASLOAD DEFS MACRO))
  (:COMPILE-LOAD      BBBLI)
  (:COMPILE-LOAD-INIT CURSO (MACRO)
		      (:FASLOAD DEFS MACRO)
		      (:FASLOAD DEFS MACRO))
  (:COMPILE-LOAD      BASEE)
  (:COMPILE-LOAD-INIT ENTYS (MACRO BASEE)
		      (:FASLOAD DEFS MACRO UTILI BASEE)
		      (:FASLOAD DEFS MACRO UTILI BASEE))
  (:COMPILE-LOAD-INIT ENTS1 (MACRO BASEE)
		      (:FASLOAD DEFS MACRO UTILI BASEE ENTYS)
		      (:FASLOAD DEFS MACRO UTILI BASEE ENTYS))
  (:COMPILE-LOAD      WORLD)
  (:COMPILE-LOAD      BASEW
		      (:FASLOAD DEFS MACRO UTILI)
		      (:FASLOAD DEFS MACRO UTILI))
  (:COMPILE-LOAD-INIT WINDO (BASEW)
		      (:FASLOAD DEFS MACRO UTILI BASEW WORLD)
		      (:FASLOAD DEFS MACRO UTILI BASEW WORLD))
  (:COMPILE-LOAD      FONT
		      (:FASLOAD DEFS MACRO UTILI BASEW WORLD WINDO)
		      (:FASLOAD DEFS MACRO UTILI BASEW WORLD WINDO))
  (:COMPILE-LOAD-INIT RASTR (MACRO BASEE)
		      (:FASLOAD DEFS MACRO BASEE UTILI BASEW WORLD WINDO FONT)
		      (:FASLOAD DEFS MACRO BASEE UTILI BASEW WORLD WINDO FONT))
  (:COMPILE-LOAD      PRINT
		      (:FASLOAD DEFS MACRO UTILI BASEW WORLD WINDO FONT))
  (:FASLOAD           RFONT
		      (:FASLOAD DEFS MACRO UTILI BASEW WORLD WINDO FONT))
  (:AUXILIARY         STARTER-KIT))
